package org.msh.tb.bd.dashboard.summaryrep.data;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by mauri on 23/05/2017.
 * Data object that stores information about a single summarized indicator
 */
public class SummaryIndicatorData {

    /**
     * The admin unit name or country name
     */
    private String locationDesc;

    /**
     * The period message key description
     */
    private String periodDesc;

    /**
     * A parameter to the period message key
     */
    private String periodDescParam;

    /**
     * The indicator code, eg 'indicator01'
     */
    private String code;

    /**
     * The rate list of the indicator
     */
    private List<IndicatorRateData> indicatorRates;

    public SummaryIndicatorData() {
        super();
    }

    public SummaryIndicatorData(String locationDesc, String periodDesc, String code, Float rate, String rateSuffix) {
        this.locationDesc = locationDesc;
        this.periodDesc = periodDesc;
        this.code = code;

        indicatorRates = new ArrayList<IndicatorRateData>();
        indicatorRates.add(new IndicatorRateData(rate,
                rateSuffix,
                null));
    }

    public SummaryIndicatorData(String locationDesc, String periodDesc, String code) {
        this.locationDesc = locationDesc;
        this.periodDesc = periodDesc;
        this.code = code;
    }

    public SummaryIndicatorData(String locationDesc, String periodDesc, String periodDescParam, String code) {
        this.locationDesc = locationDesc;
        this.periodDesc = periodDesc;
        this.periodDescParam = periodDescParam;
        this.code = code;
    }

    public void addIndicatorRate(Float rate, String rateSuffix, String rateDescMsg) {
        if (indicatorRates == null) {
            indicatorRates = new ArrayList<IndicatorRateData>();
        }

        indicatorRates.add(new IndicatorRateData(rate, rateSuffix, rateDescMsg));
    }

    public String getLocationDesc() {
        return locationDesc;
    }

    public void setLocationDesc(String locationDesc) {
        this.locationDesc = locationDesc;
    }

    public String getPeriodDesc() {
        return periodDesc;
    }

    public void setPeriodDesc(String periodDesc) {
        this.periodDesc = periodDesc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<IndicatorRateData> getIndicatorRates() {
        return indicatorRates;
    }

    public void setIndicatorRates(List<IndicatorRateData> indicatorRates) {
        this.indicatorRates = indicatorRates;
    }

    public String getPeriodDescParam() {
        return periodDescParam;
    }

    public void setPeriodDescParam(String periodDescParam) {
        this.periodDescParam = periodDescParam;
    }
}
